-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Hôte : 127.0.0.1:3306
-- Généré le : ven. 01 août 2025 à 19:04
-- Version du serveur : 9.1.0
-- Version de PHP : 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `webnlogi_farm`
--

-- --------------------------------------------------------

--
-- Structure de la table `_article`
--

DROP TABLE IF EXISTS `_article`;
CREATE TABLE IF NOT EXISTS `_article` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(30) DEFAULT NULL,
  `nom` varchar(256) DEFAULT NULL,
  `unite` varchar(20) DEFAULT NULL,
  `prix_achat` decimal(20,2) DEFAULT NULL,
  `prix_vente` decimal(20,2) DEFAULT NULL,
  `stock` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_article`
--

INSERT INTO `_article` (`id`, `code`, `nom`, `unite`, `prix_achat`, `prix_vente`, `stock`) VALUES
(1, 'PN030', 'POULE PONDEUSE', 'SAC', 138000.00, 142000.00, 0),
(2, '210AX', 'PIC DE PONTE', 'SAC', 134400.00, 138400.00, 0),
(3, '210CX', 'PONDEUSE CONCENTRE', 'SAC', 139500.00, 142000.00, 0),
(4, '225', 'FIN PONTE', 'SAC', 131375.00, 134000.00, 0),
(5, '521', 'DEMARRAGE POULET DE CHAIR', 'SAC', 179375.00, 182000.00, 0),
(6, '541', 'FINITION POULET DE CHAIR', 'SAC', 171375.00, 174000.00, 0),
(7, '542', 'POST-FINITION POULET DE CHAIR', 'SAC', 154000.00, 158000.00, 0),
(8, '1410CX', 'PORC WEANER CONCENTRE SAC DE 25KG', 'SAC', 74950.00, 76200.00, 0),
(9, '1420CX', 'CROISSANCE PORC CONCENTRE', 'SAC', 65250.00, 66500.00, 0),
(10, '1430CX', 'FINITION PORC CONCENTRE', 'SAC', 61950.00, 63200.00, 0),
(11, '1410X', 'PORC PIG WEANER CONCENTRE', 'SAC', 155675.00, 158300.00, 0),
(12, '1420X', 'CROISSANCE PORC', 'SAC', 126875.00, 129500.00, 0),
(13, '1430X', 'FINITION PORC', 'SAC', 121875.00, 124500.00, 0),
(14, '1510X', 'GESTATION', 'SAC', 131000.00, 135000.00, 0),
(15, '1520X', 'LACTATION', 'SAC', 141900.00, 145900.00, 0),
(16, 'CVL', 'RUMINANT', 'SAC', 108000.00, 112000.00, 0),
(17, 'PGO', 'TILAPIA OPTIMAL PREGROWER', 'SAC', 148000.00, 151000.00, 0),
(18, 'GO', 'GROWER OPTIMAL', 'SAC', 138000.00, 142000.00, 0),
(19, 'BC', 'BIG CRUMBLE', 'SAC', 0.00, 173000.00, 0),
(20, 'PN010', 'DEMARRAGE PONTE', 'SAC', 161000.00, 165000.00, 0),
(21, 'PN020', 'CROISSANCE PONDEUSE', 'SAC', 136875.00, 139500.00, 0),
(22, '02PSN03', 'POUSSIN CHAIR', 'U', 3670.00, 3900.00, 0),
(23, '04ATV03', 'TETRACOLIVIT 100G', 'SAC', 15000.00, 16500.00, 0),
(24, '04VIT02', 'AMINTOTAL 150G', 'SAC', 30000.00, 33000.00, 0),
(25, '04HPP01', 'ANTITOX 100G', 'SAC', 14576.00, 16000.00, 0),
(26, '04DES09', 'VIRUNET 50G', 'SAC', 12400.00, 14000.00, 0),
(27, '04ATB04', 'TRISULMYCINE 100G', 'SAC', 34599.00, 38000.00, 0),
(28, '04VIT07', 'SELIC250ML', 'SAC', 22300.00, 24500.00, 0),
(29, '04ATC01', 'ANTICOC SUPER 100G', 'SAC', 25013.00, 27500.00, 0),
(30, '06MTE06', 'MANGEOIRE MM 7KG', 'SAC', 24012.00, 32000.00, 0),
(31, '06MTE02', 'ABREUVOIR 1GAL', 'SAC', 12600.00, 17000.00, 0),
(32, '1420XF', 'CROISSANCE PORC FARINE', 'SAC', 108500.00, 117500.00, 0),
(33, '1430XF', 'FINITION PORC FARINE', 'SAC', 103500.00, 113500.00, 0),
(34, 'FP', 'FINISHER', 'SAC', 128000.00, 130000.00, 0),
(35, '1520XF', 'ALLAITEMENT FARINE', 'SAC', 116900.00, 129500.00, 0),
(36, 'KB10M', 'COMBO DEMARAGE', 'SAC', 161000.00, 167000.00, 0),
(37, 'KB20F', 'COMBO CROISSANCE', 'SAC', 135500.00, 139500.00, 0),
(38, 'KB30F', 'COMBO POULETTE', 'SAC', 138000.00, 142000.00, 0),
(39, 'KB40F', 'COMBO PONTE', 'SAC', 134400.00, 138400.00, 0),
(40, '02PSNWPF', 'COMBO POUSSIN', 'U', 4170.00, 4300.00, 0);

-- --------------------------------------------------------

--
-- Structure de la table `_balance_fournisseur`
--

DROP TABLE IF EXISTS `_balance_fournisseur`;
CREATE TABLE IF NOT EXISTS `_balance_fournisseur` (
  `id` int NOT NULL AUTO_INCREMENT,
  `affectation` varchar(100) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `fournisseur_id` int DEFAULT NULL,
  `credit` decimal(10,2) DEFAULT NULL,
  `debit` decimal(10,2) DEFAULT NULL,
  `solde` decimal(10,2) DEFAULT NULL,
  `versement_fournisseur_id` int DEFAULT NULL,
  `commande_fournisseur_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fournisseur_id` (`fournisseur_id`),
  KEY `versement_fournisseur_id` (`versement_fournisseur_id`),
  KEY `commande_fournisseur_id` (`commande_fournisseur_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_balance_fournisseur`
--

INSERT INTO `_balance_fournisseur` (`id`, `affectation`, `date`, `fournisseur_id`, `credit`, `debit`, `solde`, `versement_fournisseur_id`, `commande_fournisseur_id`) VALUES
(1, 'BILAN D\'OUVERTURE', '2025-08-01', 1, 0.00, 0.00, 0.00, NULL, NULL),
(2, 'BILAN D\'OUVERTURE', '2025-08-01', 1, 0.00, 0.00, 0.00, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `_balance_gerant`
--

DROP TABLE IF EXISTS `_balance_gerant`;
CREATE TABLE IF NOT EXISTS `_balance_gerant` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` date DEFAULT NULL,
  `date` date DEFAULT NULL,
  `affectation` varchar(100) DEFAULT NULL,
  `gerant_id` int DEFAULT NULL,
  `credit` decimal(10,2) DEFAULT NULL,
  `debit` decimal(10,2) DEFAULT NULL,
  `solde` decimal(10,2) DEFAULT NULL,
  `recette_id` int DEFAULT NULL,
  `sortie_caisse_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gerant_id` (`gerant_id`),
  KEY `recette_id` (`recette_id`),
  KEY `sortie_caisse_id` (`sortie_caisse_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_balance_gerant`
--

INSERT INTO `_balance_gerant` (`id`, `date_creation`, `date`, `affectation`, `gerant_id`, `credit`, `debit`, `solde`, `recette_id`, `sortie_caisse_id`) VALUES
(1, '2025-08-01', '2025-08-01', 'BILAN D\'OUVERTURE', 1, 0.00, 0.00, 0.00, NULL, NULL),
(2, '2025-08-01', '2025-08-01', 'BILAN D\'OUVERTURE', 1, 0.00, 0.00, 0.00, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `_balance_tiers`
--

DROP TABLE IF EXISTS `_balance_tiers`;
CREATE TABLE IF NOT EXISTS `_balance_tiers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `affectation` varchar(100) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `client_id` int DEFAULT NULL,
  `credit` decimal(10,2) DEFAULT NULL,
  `debit` decimal(10,2) DEFAULT NULL,
  `solde` decimal(10,2) DEFAULT NULL,
  `reglement_id` int DEFAULT NULL,
  `remboursement_id` int DEFAULT NULL,
  `commande_client_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `reglement_id` (`reglement_id`),
  KEY `remboursement_id` (`remboursement_id`),
  KEY `commande_client_id` (`commande_client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_bilan_caisse`
--

DROP TABLE IF EXISTS `_bilan_caisse`;
CREATE TABLE IF NOT EXISTS `_bilan_caisse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bilan_ouverture_id` int DEFAULT NULL,
  `caisse_id` int DEFAULT NULL,
  `solde` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bilan_ouverture_id` (`bilan_ouverture_id`),
  KEY `caisse_id` (`caisse_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_bilan_caisse`
--

INSERT INTO `_bilan_caisse` (`id`, `bilan_ouverture_id`, `caisse_id`, `solde`) VALUES
(1, 1, 1, 0.00),
(2, 1, 2, 0.00),
(3, 1, 3, 0.00),
(4, 1, 4, 0.00),
(5, 1, 5, 0.00);

-- --------------------------------------------------------

--
-- Structure de la table `_bilan_client`
--

DROP TABLE IF EXISTS `_bilan_client`;
CREATE TABLE IF NOT EXISTS `_bilan_client` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bilan_ouverture_id` int DEFAULT NULL,
  `client_id` int DEFAULT NULL,
  `credit_bilan` decimal(20,2) DEFAULT NULL,
  `debit_bilan` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bilan_ouverture_id` (`bilan_ouverture_id`),
  KEY `client_id` (`client_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_bilan_client`
--

INSERT INTO `_bilan_client` (`id`, `bilan_ouverture_id`, `client_id`, `credit_bilan`, `debit_bilan`) VALUES
(1, 1, 1, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Structure de la table `_bilan_fournisseur`
--

DROP TABLE IF EXISTS `_bilan_fournisseur`;
CREATE TABLE IF NOT EXISTS `_bilan_fournisseur` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bilan_ouverture_id` int DEFAULT NULL,
  `fournisseur_id` int DEFAULT NULL,
  `credit_bilan` decimal(20,2) DEFAULT NULL,
  `debit_bilan` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bilan_ouverture_id` (`bilan_ouverture_id`),
  KEY `fournisseur_id` (`fournisseur_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_bilan_fournisseur`
--

INSERT INTO `_bilan_fournisseur` (`id`, `bilan_ouverture_id`, `fournisseur_id`, `credit_bilan`, `debit_bilan`) VALUES
(1, 1, 1, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Structure de la table `_bilan_gerant`
--

DROP TABLE IF EXISTS `_bilan_gerant`;
CREATE TABLE IF NOT EXISTS `_bilan_gerant` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bilan_ouverture_id` int DEFAULT NULL,
  `gerant_id` int DEFAULT NULL,
  `credit_bilan` decimal(20,2) DEFAULT NULL,
  `debit_bilan` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bilan_ouverture_id` (`bilan_ouverture_id`),
  KEY `gerant_id` (`gerant_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_bilan_gerant`
--

INSERT INTO `_bilan_gerant` (`id`, `bilan_ouverture_id`, `gerant_id`, `credit_bilan`, `debit_bilan`) VALUES
(1, 1, 1, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Structure de la table `_bilan_ouverture`
--

DROP TABLE IF EXISTS `_bilan_ouverture`;
CREATE TABLE IF NOT EXISTS `_bilan_ouverture` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `objet` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_bilan_ouverture`
--

INSERT INTO `_bilan_ouverture` (`id`, `date_creation`, `date`, `objet`) VALUES
(1, '2025-08-01 22:03:21', '2025-08-01 00:00:00', 'INITIALISATION');

-- --------------------------------------------------------

--
-- Structure de la table `_bilan_stock`
--

DROP TABLE IF EXISTS `_bilan_stock`;
CREATE TABLE IF NOT EXISTS `_bilan_stock` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bilan_ouverture_id` int DEFAULT NULL,
  `article_id` int DEFAULT NULL,
  `quantite` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bilan_ouverture_id` (`bilan_ouverture_id`),
  KEY `article_id` (`article_id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_bilan_stock`
--

INSERT INTO `_bilan_stock` (`id`, `bilan_ouverture_id`, `article_id`, `quantite`) VALUES
(1, 1, 1, 0),
(2, 1, 2, 0),
(3, 1, 3, 0),
(4, 1, 4, 0),
(5, 1, 5, 0),
(6, 1, 6, 0),
(7, 1, 7, 0),
(8, 1, 8, 0),
(9, 1, 9, 0),
(10, 1, 10, 0),
(11, 1, 11, 0),
(12, 1, 12, 0),
(13, 1, 13, 0),
(14, 1, 14, 0),
(15, 1, 15, 0),
(16, 1, 16, 0),
(17, 1, 17, 0),
(18, 1, 18, 0),
(19, 1, 19, 0),
(20, 1, 20, 0),
(21, 1, 21, 0),
(22, 1, 22, 0),
(23, 1, 23, 0),
(24, 1, 24, 0),
(25, 1, 25, 0),
(26, 1, 26, 0),
(27, 1, 27, 0),
(28, 1, 28, 0),
(29, 1, 29, 0),
(30, 1, 30, 0),
(31, 1, 31, 0),
(32, 1, 32, 0),
(33, 1, 33, 0),
(34, 1, 34, 0),
(35, 1, 35, 0),
(36, 1, 36, 0),
(37, 1, 37, 0),
(38, 1, 38, 0),
(39, 1, 39, 0),
(40, 1, 40, 0);

-- --------------------------------------------------------

--
-- Structure de la table `_caisse`
--

DROP TABLE IF EXISTS `_caisse`;
CREATE TABLE IF NOT EXISTS `_caisse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `mode` varchar(100) DEFAULT NULL,
  `solde` decimal(20,2) DEFAULT NULL,
  `recette_val` decimal(20,2) DEFAULT NULL,
  `depense_val` decimal(20,2) DEFAULT NULL,
  `solde_bilan` decimal(20,2) DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `principal` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_caisse`
--

INSERT INTO `_caisse` (`id`, `name`, `mode`, `solde`, `recette_val`, `depense_val`, `solde_bilan`, `user_id`, `principal`) VALUES
(1, 'CAISSE DIARY', 'ESPECE', 0.00, 0.00, 0.00, 0.00, 3, 0),
(2, 'CAISSE MENDRIKA', 'ESPECE', 0.00, 0.00, 0.00, 0.00, 4, 0),
(3, 'MVOLA', 'MOBILE MONEY', 0.00, 0.00, 0.00, 0.00, NULL, 0),
(4, 'BANQUE', 'VIREMENT/CHEQUE', 0.00, 0.00, 0.00, 0.00, NULL, 0),
(5, 'CAISSE TIAVINA', 'TRANSFERT', 0.00, 0.00, 0.00, 0.00, NULL, 0);

-- --------------------------------------------------------

--
-- Structure de la table `_client`
--

DROP TABLE IF EXISTS `_client`;
CREATE TABLE IF NOT EXISTS `_client` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(30) DEFAULT NULL,
  `nom` varchar(256) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `credit` decimal(20,2) DEFAULT NULL,
  `debit` decimal(20,2) DEFAULT NULL,
  `credit_bilan` decimal(20,2) DEFAULT NULL,
  `debit_bilan` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_client`
--

INSERT INTO `_client` (`id`, `code`, `nom`, `phone`, `address`, `credit`, `debit`, `credit_bilan`, `debit_bilan`) VALUES
(1, 'FS-C999', 'DIVERS', '', '', 0.00, 0.00, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Structure de la table `_commande_client`
--

DROP TABLE IF EXISTS `_commande_client`;
CREATE TABLE IF NOT EXISTS `_commande_client` (
  `id` int NOT NULL AUTO_INCREMENT,
  `numero` varchar(50) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `client_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `net_payer` decimal(20,2) DEFAULT NULL,
  `total_remise` decimal(20,2) DEFAULT NULL,
  `montant_achat` decimal(20,2) DEFAULT NULL,
  `ref` varchar(128) DEFAULT NULL,
  `type_commande` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_commande_fournisseur`
--

DROP TABLE IF EXISTS `_commande_fournisseur`;
CREATE TABLE IF NOT EXISTS `_commande_fournisseur` (
  `id` int NOT NULL AUTO_INCREMENT,
  `numero` varchar(50) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `fournisseur_id` int DEFAULT NULL,
  `montant_commande` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fournisseur_id` (`fournisseur_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_detail_commande_client`
--

DROP TABLE IF EXISTS `_detail_commande_client`;
CREATE TABLE IF NOT EXISTS `_detail_commande_client` (
  `id` int NOT NULL AUTO_INCREMENT,
  `commande_client_id` int DEFAULT NULL,
  `article_id` int DEFAULT NULL,
  `article_code` varchar(30) DEFAULT NULL,
  `article_name` varchar(256) DEFAULT NULL,
  `prix_unit` decimal(20,2) DEFAULT NULL,
  `prix_achat` decimal(20,2) DEFAULT NULL,
  `remise` decimal(20,2) DEFAULT NULL,
  `quantite` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `commande_client_id` (`commande_client_id`),
  KEY `article_id` (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_detail_commande_fournisseur`
--

DROP TABLE IF EXISTS `_detail_commande_fournisseur`;
CREATE TABLE IF NOT EXISTS `_detail_commande_fournisseur` (
  `id` int NOT NULL AUTO_INCREMENT,
  `commande_fournisseur_id` int DEFAULT NULL,
  `article_id` int DEFAULT NULL,
  `article_code` varchar(30) DEFAULT NULL,
  `article_name` varchar(256) DEFAULT NULL,
  `prix_achat` decimal(20,2) DEFAULT NULL,
  `quantite` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `commande_fournisseur_id` (`commande_fournisseur_id`),
  KEY `article_id` (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_fournisseur`
--

DROP TABLE IF EXISTS `_fournisseur`;
CREATE TABLE IF NOT EXISTS `_fournisseur` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(30) DEFAULT NULL,
  `nom` varchar(256) DEFAULT NULL,
  `credit` decimal(20,2) DEFAULT NULL,
  `debit` decimal(20,2) DEFAULT NULL,
  `credit_bilan` decimal(20,2) DEFAULT NULL,
  `debit_bilan` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_fournisseur`
--

INSERT INTO `_fournisseur` (`id`, `code`, `nom`, `credit`, `debit`, `credit_bilan`, `debit_bilan`) VALUES
(1, '', 'LFL', 0.00, 0.00, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Structure de la table `_gerant`
--

DROP TABLE IF EXISTS `_gerant`;
CREATE TABLE IF NOT EXISTS `_gerant` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nom` varchar(100) DEFAULT NULL,
  `credit` decimal(20,2) DEFAULT NULL,
  `debit` decimal(20,2) DEFAULT NULL,
  `credit_bilan` decimal(20,2) DEFAULT NULL,
  `debit_bilan` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_gerant`
--

INSERT INTO `_gerant` (`id`, `nom`, `credit`, `debit`, `credit_bilan`, `debit_bilan`) VALUES
(1, 'LFL', 0.00, 0.00, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Structure de la table `_historique_prix`
--

DROP TABLE IF EXISTS `_historique_prix`;
CREATE TABLE IF NOT EXISTS `_historique_prix` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `article_id` int DEFAULT NULL,
  `prix_achat` decimal(20,2) DEFAULT NULL,
  `prix_vente` decimal(20,2) DEFAULT NULL,
  `motif` varchar(30) DEFAULT NULL,
  `session` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_historique_prix`
--

INSERT INTO `_historique_prix` (`id`, `date`, `article_id`, `prix_achat`, `prix_vente`, `motif`, `session`) VALUES
(1, '2025-06-30', 1, 138000.00, 142000.00, 'AJOUT', 'admin'),
(2, '2025-06-30', 2, 134400.00, 138400.00, 'AJOUT', 'admin'),
(3, '2025-06-30', 3, 139500.00, 142000.00, 'AJOUT', 'admin'),
(4, '2025-06-30', 4, 131375.00, 134000.00, 'AJOUT', 'admin'),
(5, '2025-06-30', 5, 179375.00, 182000.00, 'AJOUT', 'admin'),
(6, '2025-06-30', 6, 171375.00, 174000.00, 'AJOUT', 'admin'),
(7, '2025-06-30', 7, 154000.00, 158000.00, 'AJOUT', 'admin'),
(8, '2025-06-30', 8, 74950.00, 76200.00, 'AJOUT', 'admin'),
(9, '2025-06-30', 9, 65250.00, 66500.00, 'AJOUT', 'admin'),
(10, '2025-06-30', 10, 61950.00, 63200.00, 'AJOUT', 'admin'),
(11, '2025-06-30', 11, 155675.00, 158300.00, 'AJOUT', 'admin'),
(12, '2025-06-30', 12, 126875.00, 129500.00, 'AJOUT', 'admin'),
(13, '2025-06-30', 13, 121875.00, 124500.00, 'AJOUT', 'admin'),
(14, '2025-06-30', 14, 131000.00, 135000.00, 'AJOUT', 'admin'),
(15, '2025-06-30', 15, 141900.00, 145900.00, 'AJOUT', 'admin'),
(16, '2025-06-30', 16, 108000.00, 112000.00, 'AJOUT', 'admin'),
(17, '2025-06-30', 17, 148000.00, 151000.00, 'AJOUT', 'admin'),
(18, '2025-06-30', 18, 138000.00, 142000.00, 'AJOUT', 'admin'),
(19, '2025-06-30', 19, 0.00, 173000.00, 'AJOUT', 'admin'),
(20, '2025-06-30', 20, 161000.00, 165000.00, 'AJOUT', 'admin'),
(21, '2025-06-30', 21, 136875.00, 139500.00, 'AJOUT', 'admin'),
(22, '2025-06-30', 22, 3670.00, 3900.00, 'AJOUT', 'admin'),
(23, '2025-06-30', 23, 15000.00, 16500.00, 'AJOUT', 'admin'),
(24, '2025-06-30', 24, 30000.00, 33000.00, 'AJOUT', 'admin'),
(25, '2025-06-30', 25, 14576.00, 16000.00, 'AJOUT', 'admin'),
(26, '2025-06-30', 26, 12400.00, 14000.00, 'AJOUT', 'admin'),
(27, '2025-06-30', 27, 34599.00, 38000.00, 'AJOUT', 'admin'),
(28, '2025-06-30', 28, 22300.00, 24500.00, 'AJOUT', 'admin'),
(29, '2025-06-30', 29, 25013.00, 27500.00, 'AJOUT', 'admin'),
(30, '2025-06-30', 30, 24012.00, 32000.00, 'AJOUT', 'admin'),
(31, '2025-06-30', 31, 12600.00, 17000.00, 'AJOUT', 'admin'),
(32, '2025-06-30', 32, 108500.00, 117500.00, 'AJOUT', 'admin'),
(33, '2025-06-30', 33, 103500.00, 113500.00, 'AJOUT', 'admin'),
(34, '2025-06-30', 34, 128000.00, 130000.00, 'AJOUT', 'admin'),
(35, '2025-06-30', 35, 116900.00, 129500.00, 'AJOUT', 'admin'),
(36, '2025-06-30', 36, 161000.00, 167000.00, 'AJOUT', 'admin'),
(37, '2025-06-30', 37, 135500.00, 139500.00, 'AJOUT', 'admin'),
(38, '2025-06-30', 38, 138000.00, 142000.00, 'AJOUT', 'admin'),
(39, '2025-06-30', 39, 134400.00, 138400.00, 'AJOUT', 'admin'),
(40, '2025-06-30', 40, 4170.00, 4300.00, 'AJOUT', 'admin');

-- --------------------------------------------------------

--
-- Structure de la table `_inventaire`
--

DROP TABLE IF EXISTS `_inventaire`;
CREATE TABLE IF NOT EXISTS `_inventaire` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `fait_par` varchar(128) DEFAULT NULL,
  `commentaire` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_inventaire_detail`
--

DROP TABLE IF EXISTS `_inventaire_detail`;
CREATE TABLE IF NOT EXISTS `_inventaire_detail` (
  `id` int NOT NULL AUTO_INCREMENT,
  `article_id` int DEFAULT NULL,
  `inventaire_id` int DEFAULT NULL,
  `stock_theorique` int DEFAULT NULL,
  `stock_reel` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`),
  KEY `inventaire_id` (`inventaire_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_journal_caisse`
--

DROP TABLE IF EXISTS `_journal_caisse`;
CREATE TABLE IF NOT EXISTS `_journal_caisse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `caisse_id` int DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `affectation` varchar(100) DEFAULT NULL,
  `recette_id` int DEFAULT NULL,
  `sortie_caisse_id` int DEFAULT NULL,
  `entree` decimal(20,2) DEFAULT NULL,
  `sortie` decimal(20,2) DEFAULT NULL,
  `solde` decimal(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `caisse_id` (`caisse_id`),
  KEY `recette_id` (`recette_id`),
  KEY `sortie_caisse_id` (`sortie_caisse_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_journal_caisse`
--

INSERT INTO `_journal_caisse` (`id`, `caisse_id`, `date`, `affectation`, `recette_id`, `sortie_caisse_id`, `entree`, `sortie`, `solde`) VALUES
(1, 1, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(2, 2, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(3, 3, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(4, 4, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(5, 5, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(6, 1, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(7, 2, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(8, 3, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(9, 4, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(10, 5, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(11, 1, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(12, 2, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(13, 3, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(14, 4, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00),
(15, 5, '2025-08-01 00:00:00', 'BILAN D\'OUVERTURE', NULL, NULL, 0.00, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Structure de la table `_livraison`
--

DROP TABLE IF EXISTS `_livraison`;
CREATE TABLE IF NOT EXISTS `_livraison` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `commande_client_id` int DEFAULT NULL,
  `article_id` int DEFAULT NULL,
  `quantite` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `commande_client_id` (`commande_client_id`),
  KEY `article_id` (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_livraison_fournisseur`
--

DROP TABLE IF EXISTS `_livraison_fournisseur`;
CREATE TABLE IF NOT EXISTS `_livraison_fournisseur` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `fournisseur_id` int DEFAULT NULL,
  `commande_fournisseur_id` int DEFAULT NULL,
  `ref` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fournisseur_id` (`fournisseur_id`),
  KEY `commande_fournisseur_id` (`commande_fournisseur_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_livraison_fournisseur_detail`
--

DROP TABLE IF EXISTS `_livraison_fournisseur_detail`;
CREATE TABLE IF NOT EXISTS `_livraison_fournisseur_detail` (
  `id` int NOT NULL AUTO_INCREMENT,
  `livraison_fournisseur_id` int DEFAULT NULL,
  `article_id` int DEFAULT NULL,
  `article_code` varchar(30) DEFAULT NULL,
  `article_name` varchar(256) DEFAULT NULL,
  `prix_achat_unit` decimal(20,2) DEFAULT NULL,
  `quantite` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `livraison_fournisseur_id` (`livraison_fournisseur_id`),
  KEY `article_id` (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_log`
--

DROP TABLE IF EXISTS `_log`;
CREATE TABLE IF NOT EXISTS `_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `motif` varchar(100) DEFAULT NULL,
  `message` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_num_client`
--

DROP TABLE IF EXISTS `_num_client`;
CREATE TABLE IF NOT EXISTS `_num_client` (
  `id` int NOT NULL AUTO_INCREMENT,
  `last_number` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_num_commande`
--

DROP TABLE IF EXISTS `_num_commande`;
CREATE TABLE IF NOT EXISTS `_num_commande` (
  `id` int NOT NULL AUTO_INCREMENT,
  `last_number` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_num_depense`
--

DROP TABLE IF EXISTS `_num_depense`;
CREATE TABLE IF NOT EXISTS `_num_depense` (
  `id` int NOT NULL AUTO_INCREMENT,
  `last_number` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_num_facture`
--

DROP TABLE IF EXISTS `_num_facture`;
CREATE TABLE IF NOT EXISTS `_num_facture` (
  `id` int NOT NULL AUTO_INCREMENT,
  `last_number` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_num_recu`
--

DROP TABLE IF EXISTS `_num_recu`;
CREATE TABLE IF NOT EXISTS `_num_recu` (
  `id` int NOT NULL AUTO_INCREMENT,
  `last_number` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_poussin`
--

DROP TABLE IF EXISTS `_poussin`;
CREATE TABLE IF NOT EXISTS `_poussin` (
  `id` int NOT NULL AUTO_INCREMENT,
  `article_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_poussin`
--

INSERT INTO `_poussin` (`id`, `article_id`) VALUES
(1, 22);

-- --------------------------------------------------------

--
-- Structure de la table `_recette`
--

DROP TABLE IF EXISTS `_recette`;
CREATE TABLE IF NOT EXISTS `_recette` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ref` varchar(50) DEFAULT NULL,
  `libelle` varchar(256) DEFAULT NULL,
  `affectation` varchar(100) DEFAULT NULL,
  `montant` decimal(10,2) DEFAULT NULL,
  `caisse_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `caisse_id` (`caisse_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_reglement`
--

DROP TABLE IF EXISTS `_reglement`;
CREATE TABLE IF NOT EXISTS `_reglement` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `commande_client_id` int DEFAULT NULL,
  `montant` decimal(20,2) DEFAULT NULL,
  `mode` varchar(50) DEFAULT NULL,
  `numero_recu` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `commande_client_id` (`commande_client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_remboursement`
--

DROP TABLE IF EXISTS `_remboursement`;
CREATE TABLE IF NOT EXISTS `_remboursement` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `commande_client_id` int DEFAULT NULL,
  `montant` decimal(20,2) DEFAULT NULL,
  `mode` varchar(50) DEFAULT NULL,
  `numero_recu` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `commande_client_id` (`commande_client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_reservation_poussin`
--

DROP TABLE IF EXISTS `_reservation_poussin`;
CREATE TABLE IF NOT EXISTS `_reservation_poussin` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `client_id` int DEFAULT NULL,
  `date_reservation` datetime DEFAULT NULL,
  `prix` decimal(20,2) DEFAULT NULL,
  `quantite_commande` int DEFAULT NULL,
  `quantite_livre` int DEFAULT NULL,
  `status` varchar(30) DEFAULT NULL,
  `avance` decimal(20,2) DEFAULT NULL,
  `commande_client_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `commande_client_id` (`commande_client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_sortie_caisse`
--

DROP TABLE IF EXISTS `_sortie_caisse`;
CREATE TABLE IF NOT EXISTS `_sortie_caisse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `numero_fiche` varchar(20) NOT NULL,
  `date_sortie` date DEFAULT NULL,
  `caisse_id` int DEFAULT NULL,
  `beneficiaire` varchar(100) DEFAULT NULL,
  `montant` decimal(10,2) DEFAULT NULL,
  `libelle` varchar(50) DEFAULT NULL,
  `objet` varchar(255) DEFAULT NULL,
  `pieces_jointes` varchar(255) DEFAULT NULL,
  `responsable_caisse` varchar(256) DEFAULT NULL,
  `coursier_signature` tinyint(1) DEFAULT NULL,
  `responsable_signature` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `numero_fiche` (`numero_fiche`),
  KEY `caisse_id` (`caisse_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_transfert`
--

DROP TABLE IF EXISTS `_transfert`;
CREATE TABLE IF NOT EXISTS `_transfert` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `t_type` varchar(20) DEFAULT NULL,
  `libelle` varchar(256) DEFAULT NULL,
  `montant` decimal(10,2) DEFAULT NULL,
  `caisse_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `caisse_id` (`caisse_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Structure de la table `_user`
--

DROP TABLE IF EXISTS `_user`;
CREATE TABLE IF NOT EXISTS `_user` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `password` varchar(256) DEFAULT NULL,
  `account_type` varchar(50) DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  `timelocked` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `_user`
--

INSERT INTO `_user` (`id`, `username`, `phone`, `password`, `account_type`, `active`, `timelocked`) VALUES
(1, 'test', NULL, 'pbkdf2:sha256:150000$xi9J9AvW$fbf6d485b9a6db19d5029434b00d7a90d3a50daf9b4b8e64f16e02a8bccdd3bb', 'admin', 0, 0),
(2, 'admin', NULL, 'pbkdf2:sha256:150000$xI35etMo$78496ea4aa171f98cbccbcfb108ba45d275b160251f246946f93400a5f722072', 'admin', 1, 0),
(3, 'diary', NULL, 'pbkdf2:sha256:150000$dEFck1NZ$b1759ef083793baf2f7316daab2b77928b51bb0cd4d9317ec0f0cb0c59253de8', 'caissier', 1, 0),
(4, 'mendrika', NULL, 'pbkdf2:sha256:150000$NcNzb5db$698ea5eec44d64111aa6351aba1a5d5a805e40dd7a5084a6e2c08e84b787bfe4', 'caissier', 1, 0),
(5, 'alakamisy', NULL, 'pbkdf2:sha256:150000$uAW3DHZa$f0edeba1193934b46865dbb1980d6010f893ec7aed4b371218e2bd992aa7e4a4', 'limited', 1, 0);

-- --------------------------------------------------------

--
-- Structure de la table `_versement_fournisseur`
--

DROP TABLE IF EXISTS `_versement_fournisseur`;
CREATE TABLE IF NOT EXISTS `_versement_fournisseur` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `numero` varchar(50) DEFAULT NULL,
  `fournisseur_id` int DEFAULT NULL,
  `commande_fournisseur_id` int DEFAULT NULL,
  `sortie_caisse_id` int DEFAULT NULL,
  `montant` decimal(20,2) DEFAULT NULL,
  `frais` decimal(20,2) DEFAULT NULL,
  `mode` varchar(50) DEFAULT NULL,
  `ref` varchar(256) DEFAULT NULL,
  `piece_joint` varchar(256) DEFAULT NULL,
  `statut_encaissement` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fournisseur_id` (`fournisseur_id`),
  KEY `commande_fournisseur_id` (`commande_fournisseur_id`),
  KEY `sortie_caisse_id` (`sortie_caisse_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contraintes pour les tables déchargées
--

--
-- Contraintes pour la table `_historique_prix`
--
ALTER TABLE `_historique_prix`
  ADD CONSTRAINT `_historique_prix_ibfk_1` FOREIGN KEY (`article_id`) REFERENCES `_article` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
